% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadDirectory.R
\name{loadDirectory}
\alias{loadDirectory}
\title{Load all non-child objects in a directory}
\usage{
loadDirectory(dir, redirect.action = c("from", "to", "both"))
}
\arguments{
\item{dir}{String containing a path to a staging directory.}

\item{redirect.action}{String specifying how redirects should be handled:
\itemize{
\item \code{"to"} will report an object at the redirection destination, not the redirection source.
\item \code{"from"} will report an object at the redirection source(s), not the destination.
\item \code{"both"} will report an object at both the redirection source(s) and destination.
}}
}
\value{
A named list is returned containing all (non-child) R objects in \code{dir}.
}
\description{
\emph{WARNING: this function is deprecated, use \code{\link{listObjects}} and loop over entries with \code{\link{readObject}} instead.}
As the title suggests, this function loads all non-child objects in a staging directory.
All loading is performed using \code{\link{altLoadObject}} to respect any application-specific overrides.
Children are used to assemble their parent objects and are not reported here.
}
\examples{
tmp <- tempfile()
dir.create(tmp)

library(S4Vectors)
df <- DataFrame(A=1:10, B=LETTERS[1:10])
meta <- stageObject(df, tmp, path="whee")
writeMetadata(meta, tmp)

ll <- list(A=1, B=LETTERS, C=DataFrame(X=1:5))
meta <- stageObject(ll, tmp, path="stuff")
writeMetadata(meta, tmp)

redirect <- createRedirection(tmp, "whoop", "whee/simple.csv.gz")
writeMetadata(redirect, tmp)

all.meta <- loadDirectory(tmp)
str(all.meta) 

}
\author{
Aaron Lun
}
