% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchManifest.R
\name{fetchManifest}
\alias{fetchManifest}
\title{Fetch version manifest}
\usage{
fetchManifest(
  project,
  asset,
  version,
  cache = cacheDirectory(),
  overwrite = FALSE,
  url = restUrl(),
  config = NULL
)
}
\arguments{
\item{project}{String containing the project name.}

\item{asset}{String containing the asset name.}

\item{version}{String containing the version name.}

\item{cache}{String containing the cache directory.
If \code{NULL}, no caching is performed.}

\item{overwrite}{Logical scalar indicating whether to overwrite an existing file in \code{cache}, if one is present.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{config}{Deprecated and ignored.}
}
\value{
List containing the manifest for this version.
Each element is named after the relative path of a file in this version.
The value of each element is another list with the following fields:
\itemize{
\item \code{size}, an integer specifying the size of the file in bytes.
\item \code{md5sum}, a string containing the hex-encoded MD5 checksum of the file.
\item \code{link} (optional): a list specifying the link destination for a file. 
This contains the strings \code{project}, \code{asset}, \code{version} and \code{path}.
If the link destination is itself a link, an \code{ancestor} list will be present that specifies the final location of the file after resolving all intermediate links.
}
}
\description{
Fetch the manifest for a version of an asset of a project.
}
\examples{
fetchManifest("test-R", "basic", "v1")

}
\author{
Aaron Lun
}
