% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countErccMolecules.R
\name{countErccMolecules}
\alias{countErccMolecules}
\title{Obtain ERCC molecule counts from concentrations}
\usage{
countErccMolecules(volume, dilution, mix = c("1", "2"), ...)
}
\arguments{
\item{volume}{Numeric scalar specifying the added volume (in microliters) of ERCC spike-in mixture.}

\item{dilution}{Numeric scalar specifying the dilution factor used for the added volume of the spike-in mixture.}

\item{mix}{String specifying whether to compute the number of molecules for mix 1 or 2.}

\item{...}{Further arguments to pass to \code{\link{fetchDataset}}.}
}
\value{
A \linkS4class{DataFrame} object with one row per ERCC spike-in transcript.
This contains the estimated concentration and molecule count for each transcript.
}
\description{
Compute the number of molecules for each transcript in the ERCC spike-in mixture,
based on their published concentration as well as the volume of the diluted mixture added to each cell.
}
\examples{
countErccMolecules(volume = 9, dilution = 300000)

}
\author{
Aaron Lun, based on code from Alan O'Callaghan
}
