% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_graph_from_graph_series.R
\name{render_graph_from_graph_series}
\alias{render_graph_from_graph_series}
\title{Render a graph available in a series}
\usage{
render_graph_from_graph_series(
  graph_series,
  graph_no,
  output = "graph",
  width = NULL,
  height = NULL
)
}
\arguments{
\item{graph_series}{A graph series object of type \code{dgr_graph_1D}.}

\item{graph_no}{The index of the graph in the graph series.}

\item{output}{A string specifying the output type; \code{graph} (the default)
renders the graph using the \code{\link[=grViz]{grViz()}} function and \code{visNetwork} renders the
graph using the \code{\link[=visnetwork]{visnetwork()}} function.}

\item{width}{An optional parameter for specifying the width of the resulting
graphic in pixels.}

\item{height}{An optional parameter for specifying the height of the
resulting graphic in pixels.}
}
\description{
Using a graph series object of type \code{dgr_graph_1D}, either render graph in
the Viewer or output in various formats.
}
\examples{
\dontrun{
# Create three graphs
graph_1 <-
  create_graph() \%>\%
  add_path(n = 4)

graph_2 <-
  create_graph() \%>\%
  add_cycle(n = 5)

graph_3 <-
  create_graph() \%>\%
  add_star(n = 6)

# Create an empty graph series
# and add the graphs
series <-
  create_graph_series() \%>\%
  add_graph_to_graph_series(
    graph = graph_1) \%>\%
  add_graph_to_graph_series(
    graph = graph_2) \%>\%
  add_graph_to_graph_series(
    graph = graph_3)

# View the second graph in
# the series in the Viewer
render_graph_from_graph_series(
  graph_series = series,
  graph_no = 2)
}

}
\seealso{
Other Display and Save: 
\code{\link{export_graph}()},
\code{\link{render_graph}()},
\code{\link{save_graph}()}
}
\concept{Display and Save}
