% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_edge_attrs_ws.R
\name{set_edge_attrs_ws}
\alias{set_edge_attrs_ws}
\title{Set edge attributes with an edge selection}
\usage{
set_edge_attrs_ws(graph, edge_attr, value)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edge_attr}{The name of the attribute to set.}

\item{value}{The value to be set for the chosen attribute for the edges in
the current selection.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph} or an edge data frame, set edge
attribute properties for one or more edges.

This function makes use of an active selection of edges (and the function
ending with \verb{_ws} hints at this).

Selections of edges can be performed using the following selection
(\verb{select_*()}) functions: \code{\link[=select_edges]{select_edges()}}, \code{\link[=select_last_edges_created]{select_last_edges_created()}},
\code{\link[=select_edges_by_edge_id]{select_edges_by_edge_id()}}, or \code{\link[=select_edges_by_node_id]{select_edges_by_node_id()}}.

Selections of edges can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out_edge]{trav_out_edge()}}, \code{\link[=trav_in_edge]{trav_in_edge()}},
\code{\link[=trav_both_edge]{trav_both_edge()}}, or \code{\link[=trav_reverse_edge]{trav_reverse_edge()}}.
}
\examples{
# Create a simple graph
graph <-
  create_graph() \%>\%
  add_path(n = 6)

# Select specific edges from
# the graph and apply the edge
# attribute `color = blue` to
# those selected edges
graph <-
  graph \%>\%
  select_nodes_by_id(nodes = 2:4) \%>\%
  trav_out_edge() \%>\%
  set_edge_attrs_ws(
    edge_attr = color,
    value = "blue")

# Show the internal edge data
# frame to verify that the
# edge attribute has been set
# for specific edges
graph \%>\% get_edge_df()

}
\seealso{
Other edge creation and removal: 
\code{\link{add_edge}()},
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edge}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs}()}
}
\concept{edge creation and removal}
