## TFSA-2021-155: NPE in TFLite

### CVE Number
CVE-2021-37681

### Impact
The implementation of SVDF in TFLite is [vulnerable to a null pointer
error](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/lite/kernels/svdf.cc#L300-L313):

```cc
  TfLiteTensor* state = GetVariableInput(context, node, kStateTensor);
  // ...
  GetTensorData<float>(state)
```

The [`GetVariableInput`
function](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/lite/kernels/kernel_util.cc#L115-L119)
can return a null pointer but `GetTensorData` assumes that the argument is
always a valid tensor.

```cc
TfLiteTensor* GetVariableInput(TfLiteContext* context, const TfLiteNode* node,
                               int index) {
  TfLiteTensor* tensor = GetMutableInput(context, node, index);
  return tensor->is_variable ? tensor : nullptr;
}
```

Furthermore, because `GetVariableInput` calls
[`GetMutableInput`](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/lite/kernels/kernel_util.cc#L82-L90)
which might return `nullptr`, the `tensor->is_variable` expression can also
trigger a null pointer exception.

### Patches
We have patched the issue in GitHub commit
[5b048e87e4e55990dae6b547add4dae59f4e1c76](https://github.com/tensorflow/tensorflow/commit/5b048e87e4e55990dae6b547add4dae59f4e1c76).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
