/* Copyright (C) 2002-2005 RealVNC Ltd.  All Rights Reserved.
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

// -=- ServerCore.h

// This header will define the Server interface, from which ServerMT and
// ServerST will be derived.

#ifndef __RFB_SERVER_CORE_H__
#define __RFB_SERVER_CORE_H__

#include <rfb/Configuration.h>
#include <rfb/util.h>

namespace rfb {

  class Server {
  public:

    static IntParameter idleTimeout;
    static IntParameter maxDisconnectionTime;
    static IntParameter maxConnectionTime;
    static IntParameter maxIdleTime;
    static IntParameter compareFB;
    static IntParameter frameRate;
    static BoolParameter protocol3_3;
    static BoolParameter alwaysShared;
    static BoolParameter neverShared;
    static BoolParameter disconnectClients;
    static BoolParameter acceptKeyEvents;
    static BoolParameter acceptPointerEvents;
    static BoolParameter acceptCutText;
    static BoolParameter sendCutText;
    static BoolParameter acceptSetDesktopSize;
    static BoolParameter queryConnect;

  };

};

#endif // __RFB_SERVER_CORE_H__

