# -*- coding: utf-8 -*-

import sys
import os
import time
import re


sys.path.insert(0, os.path.abspath('.'))


def get_version():
    patterns = [
            r'^set\(UFO_FILTERS_VERSION_MAJOR "(\d*)"\)',
            r'^set\(UFO_FILTERS_VERSION_MINOR "(\d*)"\)',
            r'^set\(UFO_FILTERS_VERSION_PATCH "(\d*)"\)'
            ]
    version = ["0", "0", "0"]

    with open('../CMakeLists.txt', 'r') as f:
        lines = f.readlines()
        major_pattern = r'^set\(UFO_FILTERS_VERSION_MAJOR "(\d*)"\)'

        for line in lines:
            for i, pattern in enumerate(patterns):
                m = re.match(pattern, line)

                if m:
                    version[i] = m.group(1)

    return '.'.join(version)


project = u'UFO Tasks'
copyright = u'%s, UFO Collaboration' % time.strftime('%Y')
version = get_version()
release = version

extensions = [
    'sphinx.ext.mathjax',
    'sphinxgobject',
    'sphinxcontrib.bibtex'
]
templates_path = ['_templates']

master_doc = 'index'
source_suffix = '.rst'

exclude_patterns = ['_build']
pygments_style = None

html_theme = 'sphinx_rtd_theme'
html_static_path = ['_static']
html_css_files = [
    'css/custom.css'
]
html_style = 'css/custom.css'
htmlhelp_basename = 'ufo-filtersdoc'

latex_documents = [
  ('index', 'ufo-filters.tex', u'UFO Tasks Reference',
   u'Matthias Vogelgesang', 'manual'),
]

bibtex_bibfiles = ['refs.bib']
bibtex_reference_style = 'author_year'
