/* Generated by wbuild from "Frame.w"
** (generator version $Revision: 2.0 $ of $Date: 93/07/06 16:08:04 $)
*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <string.h>
#include <stdio.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/CharSet.h>
#include "stip4.bm"
#include "FrameP.h"
static void set_shadow(Widget,XEvent*,String*,Cardinal*);

static XtActionsRec actionsList[] = {
{"set_shadow", set_shadow},
};
static void _resolve_inheritance(WidgetClass);
static void class_initialize(void);
static void initialize(Widget ,Widget,ArgList ,Cardinal *);
static void realize(Widget,XtValueMask *,XSetWindowAttributes *);
static Boolean  set_values(Widget ,Widget ,Widget,ArgList ,Cardinal *);
static void expose(Widget,XEvent *,Region );
static void compute_inside(Widget,Position *,Position *,Dimension *,Dimension *);
static XtGeometryResult  query_geometry(Widget,XtWidgetGeometry *,XtWidgetGeometry *);
static XtGeometryResult  geometry_manager(Widget ,XtWidgetGeometry *,XtWidgetGeometry *);
static void resize(Widget);
static void change_managed(Widget);
#define done(type, value) do {\
      if (to->addr != NULL) {\
	  if (to->size < sizeof(type)) {\
	      to->size = sizeof(type);\
	      return False;\
	  }\
	  *(type*)(to->addr) = (value);\
      } else {\
	  static type static_val;\
	  static_val = (value);\
	  to->addr = (XtPointer)&static_val;\
      }\
      to->size = sizeof(type);\
      return True;\
  }while (0 )


static char  rcsid[] = "$Header: Frame.w,v 1.5 92/11/02 14:07:52 bert Exp $";
static void create_darkgc(Widget);
static void create_lightgc(Widget);
static void compute_topcolor(Widget,int ,XrmValue *);
static void compute_bottomcolor(Widget,int ,XrmValue *
);

/*ARGSUSED*/static void create_darkgc(Widget self)
{
    XtGCMask mask;
    XGCValues values;

    if (((XfwfFrameWidget)self)->xfwfFrame.darkgc != NULL) XtReleaseGC(self, ((XfwfFrameWidget)self)->xfwfFrame.darkgc);
    switch (((XfwfFrameWidget)self)->xfwfFrame.shadowScheme) {
    case XfwfColor:
	mask = GCForeground;
	values.foreground = ((XfwfFrameWidget)self)->xfwfFrame.bottomShadowColor;
	break;
    case XfwfStipple:
	mask = GCFillStyle | GCStipple | GCForeground | GCBackground;
	values.fill_style = FillOpaqueStippled;
	values.stipple = ((XfwfFrameWidget)self)->xfwfFrame.bottomShadowStipple;
	values.foreground = BlackPixelOfScreen(XtScreen(self));
	values.background = ((XfwfFrameWidget)self)->core.background_pixel;
	break;
    case XfwfAuto:
	if (DefaultDepthOfScreen(XtScreen(self)) > 4
	    && ((XfwfFrameWidgetClass)self->core.widget_class)->xfwfCommon_class.darker_color(self, ((XfwfFrameWidget)self)->core.background_pixel, &values.foreground)) {
	    mask = GCForeground;
	} else {
	    mask = GCFillStyle | GCBackground | GCForeground | GCStipple;
	    values.fill_style = FillOpaqueStippled;
	    values.background = ((XfwfFrameWidget)self)->core.background_pixel;
	    values.foreground = WhitePixelOfScreen(XtScreen(self));
	    values.stipple = ((XfwfFrameWidget)self)->xfwfFrame.stip4;
	}
	break;
    }
    ((XfwfFrameWidget)self)->xfwfFrame.darkgc = XtGetGC(self, mask, &values);
}
/*ARGSUSED*/static void create_lightgc(Widget self)
{
    XtGCMask mask;
    XGCValues values;

    if (((XfwfFrameWidget)self)->xfwfFrame.lightgc != NULL) XtReleaseGC(self, ((XfwfFrameWidget)self)->xfwfFrame.lightgc);
    switch (((XfwfFrameWidget)self)->xfwfFrame.shadowScheme) {
    case XfwfColor:
	mask = GCForeground;
	values.foreground = ((XfwfFrameWidget)self)->xfwfFrame.topShadowColor;
	break;
    case XfwfStipple:
	mask = GCFillStyle | GCStipple | GCForeground | GCBackground;
	values.fill_style = FillOpaqueStippled;
	values.background = ((XfwfFrameWidget)self)->core.background_pixel;
	values.stipple = ((XfwfFrameWidget)self)->xfwfFrame.topShadowStipple;
	values.foreground = WhitePixelOfScreen(XtScreen(self));
	break;
    case XfwfAuto:
	if (DefaultDepthOfScreen(XtScreen(self)) > 4
	    && ((XfwfFrameWidgetClass)self->core.widget_class)->xfwfCommon_class.lighter_color(self, ((XfwfFrameWidget)self)->core.background_pixel, &values.foreground)) {
	    mask = GCForeground;
	} else {
	    mask = GCFillStyle | GCBackground | GCForeground | GCStipple;
	    values.fill_style = FillOpaqueStippled;
	    values.background = ((XfwfFrameWidget)self)->core.background_pixel;
	    values.foreground = WhitePixelOfScreen(XtScreen(self));
	    values.stipple = ((XfwfFrameWidget)self)->xfwfFrame.stip4;
	}
	break;
    }
    ((XfwfFrameWidget)self)->xfwfFrame.lightgc = XtGetGC(self, mask, &values);
}
/*ARGSUSED*/static void compute_topcolor(Widget self, int offset, XrmValue *value)
{
    static Pixel color;
    ((XfwfFrameWidgetClass)self->core.widget_class)->xfwfCommon_class.lighter_color(self, ((XfwfFrameWidget)self)->core.background_pixel, &color);
    value->addr = (XtPointer) &color;
}
/*ARGSUSED*/static void compute_bottomcolor(Widget self, int offset, XrmValue *value)
{
    static Pixel color;
    ((XfwfFrameWidgetClass)self->core.widget_class)->xfwfCommon_class.darker_color(self, ((XfwfFrameWidget)self)->core.background_pixel, &color);
    value->addr = (XtPointer) &color;
}

static XtResource resources[] = {
{XtNcursor,XtCCursor,XtRCursor,sizeof(((XfwfFrameRec*)NULL)->xfwfFrame.cursor),XtOffsetOf(XfwfFrameRec,xfwfFrame.cursor),XtRImmediate,(XtPointer)None },
{XtNframeType,XtCFrameType,XtRFrameType,sizeof(((XfwfFrameRec*)NULL)->xfwfFrame.frameType),XtOffsetOf(XfwfFrameRec,xfwfFrame.frameType),XtRImmediate,(XtPointer)XfwfRaised },
{XtNframeWidth,XtCFrameWidth,XtRDimension,sizeof(((XfwfFrameRec*)NULL)->xfwfFrame.frameWidth),XtOffsetOf(XfwfFrameRec,xfwfFrame.frameWidth),XtRImmediate,(XtPointer)0 },
{XtNouterOffset,XtCOuterOffset,XtRDimension,sizeof(((XfwfFrameRec*)NULL)->xfwfFrame.outerOffset),XtOffsetOf(XfwfFrameRec,xfwfFrame.outerOffset),XtRImmediate,(XtPointer)0 },
{XtNinnerOffset,XtCInnerOffset,XtRDimension,sizeof(((XfwfFrameRec*)NULL)->xfwfFrame.innerOffset),XtOffsetOf(XfwfFrameRec,xfwfFrame.innerOffset),XtRImmediate,(XtPointer)0 },
{XtNshadowScheme,XtCShadowScheme,XtRShadowScheme,sizeof(((XfwfFrameRec*)NULL)->xfwfFrame.shadowScheme),XtOffsetOf(XfwfFrameRec,xfwfFrame.shadowScheme),XtRImmediate,(XtPointer)XfwfAuto },
{XtNtopShadowColor,XtCTopShadowColor,XtRPixel,sizeof(((XfwfFrameRec*)NULL)->xfwfFrame.topShadowColor),XtOffsetOf(XfwfFrameRec,xfwfFrame.topShadowColor),XtRCallProc,(XtPointer)compute_topcolor },
{XtNbottomShadowColor,XtCBottomShadowColor,XtRPixel,sizeof(((XfwfFrameRec*)NULL)->xfwfFrame.bottomShadowColor),XtOffsetOf(XfwfFrameRec,xfwfFrame.bottomShadowColor),XtRCallProc,(XtPointer)compute_bottomcolor },
{XtNtopShadowStipple,XtCTopShadowStipple,XtRBitmap,sizeof(((XfwfFrameRec*)NULL)->xfwfFrame.topShadowStipple),XtOffsetOf(XfwfFrameRec,xfwfFrame.topShadowStipple),XtRImmediate,(XtPointer)NULL },
{XtNbottomShadowStipple,XtCBottomShadowStipple,XtRBitmap,sizeof(((XfwfFrameRec*)NULL)->xfwfFrame.bottomShadowStipple),XtOffsetOf(XfwfFrameRec,xfwfFrame.bottomShadowStipple),XtRImmediate,(XtPointer)NULL },
{XtNborderWidth,XtCBorderWidth,XtRDimension,sizeof(((XfwfFrameRec*)NULL)->core.border_width),XtOffsetOf(XfwfFrameRec,core.border_width),XtRImmediate,(XtPointer)0 },
};

XfwfFrameClassRec xfwfFrameClassRec = {
{ /* core_class part */
(WidgetClass) &xfwfCommonClassRec,
"Frame",
sizeof(XfwfFrameRec),
class_initialize,
_resolve_inheritance,
FALSE,
initialize,
NULL,
realize,
actionsList,
1,
resources,
11,
NULLQUARK,
False ,
FALSE ,
False ,
False ,
NULL,
resize,
expose,
set_values,
NULL,
XtInheritSetValuesAlmost,
NULL,
XtInheritAcceptFocus,
XtVersion,
NULL,
NULL,
query_geometry,
XtInheritDisplayAccelerator,
NULL 
},
{ /* composite_class part */
geometry_manager,
change_managed,
XtInheritInsertChild,
XtInheritDeleteChild,
NULL
},
{ /* XfwfCommon_class part */
compute_inside,
XtInherit_highlight_border,
XtInherit_unhighlight_border,
XtInherit_would_accept_focus,
XtInherit_traverse,
XtInherit_choose_color,
XtInherit_lighter_color,
XtInherit_darker_color,
NULL ,
},
{ /* XfwfFrame_class part */
0
},
};
WidgetClass xfwfFrameWidgetClass = (WidgetClass) &xfwfFrameClassRec;
/*ARGSUSED*/
static void set_shadow(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    Position x, y;
    Dimension w, h;
    FrameType f = XfwfSunken;

    if (*num_params == 0) f = ((XfwfFrameWidget)self)->xfwfFrame.old_frame_type;	/* Reset to old style */
    else if (strcmp("raised", params[0]) == 0) f = XfwfRaised;
    else if (strcmp("sunken", params[0]) == 0) f = XfwfSunken;
    else if (strcmp("chiseled", params[0]) == 0) f = XfwfChiseled;
    else if (strcmp("ledged", params[0]) == 0) f = XfwfLedged;
    else XtWarning("Unknown frame type in set_shadow action");

    if (((XfwfFrameWidget)self)->xfwfFrame.frameType != f) {
	((XfwfFrameWidget)self)->xfwfFrame.frameType = f;
	xfwfCommonClassRec.xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
	XfwfDrawFrame(self, x + ((XfwfFrameWidget)self)->xfwfFrame.outerOffset, y + ((XfwfFrameWidget)self)->xfwfFrame.outerOffset,
		      w - 2*((XfwfFrameWidget)self)->xfwfFrame.outerOffset, h - 2*((XfwfFrameWidget)self)->xfwfFrame.outerOffset,
		      ((XfwfFrameWidget)self)->xfwfFrame.frameType, ((XfwfFrameWidget)self)->xfwfFrame.frameWidth, ((XfwfFrameWidget)self)->xfwfFrame.lightgc, ((XfwfFrameWidget)self)->xfwfFrame.darkgc);
    }
}

static void _resolve_inheritance(WidgetClass class)
{
  XfwfFrameWidgetClass c = (XfwfFrameWidgetClass) class;
  XfwfFrameWidgetClass super;
  static CompositeClassExtensionRec extension_rec = {
    NULL, NULLQUARK, XtCompositeExtensionVersion,
    sizeof(CompositeClassExtensionRec), True};
  CompositeClassExtensionRec *ext;
  ext = (XtPointer)XtMalloc(sizeof(*ext));
  *ext = extension_rec;
  ext->next_extension = c->composite_class.extension;
  c->composite_class.extension = ext;
  if (class == xfwfFrameWidgetClass) return;
  super = (XfwfFrameWidgetClass)class->core_class.superclass;
}
/*ARGSUSED*/static void class_initialize(void)
{
    static XtConvertArgRec screenArg[] = {
    {XtBaseOffset, (XtPointer)XtOffset(Widget, core.screen), sizeof(Screen*)}};

    XtSetTypeConverter(XtRString, XtRFrameType, cvtStringToFrameType,
		       NULL, 0, XtCacheNone, NULL);
    XtSetTypeConverter(XtRFrameType, XtRString, cvtFrameTypeToString,
		       NULL, 0, XtCacheNone, NULL);

    XtAddConverter(XtRString, XtRBitmap, XmuCvtStringToBitmap,
		       screenArg, XtNumber(screenArg));

    XtSetTypeConverter(XtRString, XtRShadowScheme, cvtStringToShadowScheme,
		       NULL, 0, XtCacheNone, NULL);
    XtSetTypeConverter(XtRShadowScheme, XtRString, cvtShadowSchemeToString,
		       NULL, 0, XtCacheNone, NULL);
}
/*ARGSUSED*/static void initialize(Widget request, Widget self, ArgList args, Cardinal *num_args)
{
    ((XfwfFrameWidget)self)->xfwfFrame.lightgc = NULL;
    ((XfwfFrameWidget)self)->xfwfFrame.darkgc = NULL;
    ((XfwfFrameWidget)self)->xfwfFrame.old_frame_type = ((XfwfFrameWidget)self)->xfwfFrame.frameType;
}
/*ARGSUSED*/static void realize(Widget self, XtValueMask *mask, XSetWindowAttributes *attributes)
{
#ifdef USE_CWCURSOR
    *mask |= CWCursor;
#endif
    attributes->cursor = ((XfwfFrameWidget)self)->xfwfFrame.cursor;
    xfwfCommonClassRec.core_class.realize(self, mask, attributes);

    ((XfwfFrameWidget)self)->xfwfFrame.stip4 = XCreateBitmapFromData(XtDisplay(self), XtWindow(self),
        stip4_bits, stip4_width, stip4_height);

    if (! ((XfwfFrameWidget)self)->xfwfFrame.topShadowStipple) ((XfwfFrameWidget)self)->xfwfFrame.topShadowStipple = ((XfwfFrameWidget)self)->xfwfFrame.stip4;
    if (! ((XfwfFrameWidget)self)->xfwfFrame.bottomShadowStipple) ((XfwfFrameWidget)self)->xfwfFrame.bottomShadowStipple = ((XfwfFrameWidget)self)->xfwfFrame.stip4;

    create_lightgc(self);
    create_darkgc(self);
}
/*ARGSUSED*/static Boolean  set_values(Widget old, Widget request, Widget self, ArgList args, Cardinal *num_args)
{
    Boolean need_redisplay = False;

    if (((XfwfFrameWidget)self)->xfwfFrame.cursor != ((XfwfFrameWidget)old)->xfwfFrame.cursor && XtIsRealized(self))
	XDefineCursor(XtDisplay(self), XtWindow(self), ((XfwfFrameWidget)self)->xfwfFrame.cursor);

    if (((XfwfFrameWidget)self)->xfwfFrame.frameType == XfwfChiseled || ((XfwfFrameWidget)self)->xfwfFrame.frameType == XfwfLedged)
	((XfwfFrameWidget)self)->xfwfFrame.frameWidth = 2 * ((int) (((XfwfFrameWidget)self)->xfwfFrame.frameWidth / 2));

    if (((XfwfFrameWidget)self)->xfwfFrame.shadowScheme != ((XfwfFrameWidget)old)->xfwfFrame.shadowScheme) {
	create_darkgc(self);
	create_lightgc(self);
	need_redisplay = True;
    } else if (((XfwfFrameWidget)self)->xfwfFrame.shadowScheme == XfwfColor) {
	if (((XfwfFrameWidget)self)->xfwfFrame.topShadowColor != ((XfwfFrameWidget)old)->xfwfFrame.topShadowColor) {
	    create_lightgc(self);
	    need_redisplay = True;
	}
	if (((XfwfFrameWidget)self)->xfwfFrame.bottomShadowColor != ((XfwfFrameWidget)old)->xfwfFrame.bottomShadowColor) {
	    create_darkgc(self);
	    need_redisplay = True;
	}
    } else if (((XfwfFrameWidget)self)->xfwfFrame.shadowScheme == XfwfStipple) {
	if (((XfwfFrameWidget)self)->xfwfFrame.topShadowStipple != ((XfwfFrameWidget)old)->xfwfFrame.topShadowStipple) {
	    create_lightgc(self);
	    need_redisplay = True;
	}
	if (((XfwfFrameWidget)self)->xfwfFrame.bottomShadowStipple != ((XfwfFrameWidget)old)->xfwfFrame.bottomShadowStipple) {
	    create_darkgc(self);
	    need_redisplay = True;
	}
    }

    if (((XfwfFrameWidget)self)->xfwfFrame.outerOffset != ((XfwfFrameWidget)old)->xfwfFrame.outerOffset)
	need_redisplay = True;

    if (((XfwfFrameWidget)self)->xfwfFrame.innerOffset != ((XfwfFrameWidget)old)->xfwfFrame.innerOffset)
	need_redisplay = True;

    if (((XfwfFrameWidget)self)->xfwfFrame.frameType != ((XfwfFrameWidget)old)->xfwfFrame.frameType) {
	((XfwfFrameWidget)self)->xfwfFrame.old_frame_type = ((XfwfFrameWidget)self)->xfwfFrame.frameType;
	need_redisplay = True;
    }

    if (((XfwfFrameWidget)self)->xfwfFrame.frameWidth != ((XfwfFrameWidget)old)->xfwfFrame.frameWidth)
	need_redisplay = True;
    else if (((XfwfFrameWidget)self)->xfwfFrame.frameWidth == 0)
	need_redisplay = False;

    return need_redisplay;
}
/*ARGSUSED*/static void expose(Widget self, XEvent *event, Region region)
{
    Position x, y;
    Dimension w, h;

    if (! XtIsRealized(self)) return;
    if (region != NULL) {
	XSetRegion(XtDisplay(self), ((XfwfFrameWidget)self)->xfwfFrame.lightgc, region);
	XSetRegion(XtDisplay(self), ((XfwfFrameWidget)self)->xfwfFrame.darkgc, region);
    }
    xfwfCommonClassRec.xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
    XfwfDrawFrame(self, x + ((XfwfFrameWidget)self)->xfwfFrame.outerOffset, y + ((XfwfFrameWidget)self)->xfwfFrame.outerOffset, w - 2*((XfwfFrameWidget)self)->xfwfFrame.outerOffset,
	 h - 2*((XfwfFrameWidget)self)->xfwfFrame.outerOffset, ((XfwfFrameWidget)self)->xfwfFrame.frameType, ((XfwfFrameWidget)self)->xfwfFrame.frameWidth, ((XfwfFrameWidget)self)->xfwfFrame.lightgc, ((XfwfFrameWidget)self)->xfwfFrame.darkgc);
    if (region != NULL) {
	XSetClipMask(XtDisplay(self), ((XfwfFrameWidget)self)->xfwfFrame.lightgc, None);
	XSetClipMask(XtDisplay(self), ((XfwfFrameWidget)self)->xfwfFrame.darkgc, None);
    }
    xfwfCommonClassRec.core_class.expose(self, event, region);
}
/*ARGSUSED*/static void compute_inside(Widget self, Position *x, Position *y, Dimension *w, Dimension *h)
{
    int ww, hh;		/* DCT */

    xfwfCommonClassRec.xfwfCommon_class.compute_inside(self, x, y, w, h);
    *x += ((XfwfFrameWidget)self)->xfwfFrame.outerOffset + ((XfwfFrameWidget)self)->xfwfFrame.frameWidth + ((XfwfFrameWidget)self)->xfwfFrame.innerOffset;
    *y += ((XfwfFrameWidget)self)->xfwfFrame.outerOffset + ((XfwfFrameWidget)self)->xfwfFrame.frameWidth + ((XfwfFrameWidget)self)->xfwfFrame.innerOffset;

    /* 17Mar94 DCT - keep w,h from wrapping around to 65xxxx. */

/* For reasons which are not clear avoiding wrap-around here causes
 * geometry management to fail in some circumstances while determining the
 * initial frame size during startup.
 *
 *  ww = *w;
 *  *w = max (0, ww - 2 * (((XfwfFrameWidget)self)->xfwfFrame.outerOffset +
 *	((XfwfFrameWidget)self)->xfwfFrame.frameWidth +
 *	((XfwfFrameWidget)self)->xfwfFrame.innerOffset));
 *  hh = *h;
 *  *h = max (0, hh - 2 * (((XfwfFrameWidget)self)->xfwfFrame.outerOffset +
 *	((XfwfFrameWidget)self)->xfwfFrame.frameWidth +
 *	((XfwfFrameWidget)self)->xfwfFrame.innerOffset));
 */
    *w -= 2 * (((XfwfFrameWidget)self)->xfwfFrame.outerOffset + ((XfwfFrameWidget)self)->xfwfFrame.frameWidth + ((XfwfFrameWidget)self)->xfwfFrame.innerOffset);
    *h -= 2 * (((XfwfFrameWidget)self)->xfwfFrame.outerOffset + ((XfwfFrameWidget)self)->xfwfFrame.frameWidth + ((XfwfFrameWidget)self)->xfwfFrame.innerOffset);
}

/*ARGSUSED*/static XtGeometryResult  query_geometry(Widget self, XtWidgetGeometry *request, XtWidgetGeometry *reply)
{
    XtWidgetGeometry request2, reply2;
    XtGeometryResult result;
    Dimension h;

    if (((XfwfFrameWidget)self)->composite.num_children == 0) return XtGeometryYes;

    /* We're only interested in size and stacking order */
    reply->request_mode =
	(CWWidth | CWHeight | CWStackMode) & request->request_mode;

    /* If nothing of interest is left, we can return immediately */
    if (reply->request_mode == 0)
	return XtGeometryYes;

    /* Prepare a request to the child */
    h = 2 * (((XfwfFrameWidget)self)->xfwfFrame.outerOffset + ((XfwfFrameWidget)self)->xfwfFrame.frameWidth + ((XfwfFrameWidget)self)->xfwfFrame.innerOffset);
    request2.request_mode = reply->request_mode;
    request2.width = request->width - h;
    request2.height = request->height - h;
    request2.sibling = request->sibling;
    request2.stack_mode = request->stack_mode;

    result = XtQueryGeometry(((XfwfFrameWidget)self)->composite.children[0], &request2, &reply2);

    /* If the child accepted its proposal, we accept ours */
    if (result == XtGeometryYes) return XtGeometryYes;

    /* If the child doesn't want any change, we don't want any, either */
    if (result == XtGeometryNo) return XtGeometryNo;

    /* Otherwise, ignore everything but size and stacking order */
    reply->request_mode &= reply2.request_mode;
    if (reply->request_mode == 0) return XtGeometryYes;

    reply->width = reply2.width + h;
    reply->height = reply2.height + h;
    reply->sibling = reply2.sibling;
    reply->stack_mode = reply2.stack_mode;
    return XtGeometryAlmost;
}
/*ARGSUSED*/static XtGeometryResult  geometry_manager(Widget child, XtWidgetGeometry *request, XtWidgetGeometry *reply)
{ Widget self = XtParent(child); {
    XtWidgetGeometry request2, reply2;
    XtGeometryResult result;
    Position x, y;
    Dimension w, h, extraw, extrah;

    ((XfwfFrameWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
    if (! (request->request_mode & (CWWidth|CWHeight))) return XtGeometryYes;
    extraw = ((XfwfFrameWidget)self)->core.width - w;
    extrah = ((XfwfFrameWidget)self)->core.height - h;
    request2.request_mode = request->request_mode & (CWWidth|CWHeight);
    request2.width = request->width + extraw;
    request2.height = request->height + extrah;
    result = XtMakeGeometryRequest(self, &request2, &reply2);
    if (result == XtGeometryNo) return XtGeometryNo;
    if (result == XtGeometryYes) return XtGeometryYes;
    reply->request_mode = reply2.request_mode & (CWWidth|CWHeight);
    reply->width = reply2.width - extraw;
    reply->height = reply2.height - extrah;
    return XtGeometryAlmost;
}
}
/*ARGSUSED*/static void resize(Widget self)
{
    Position x, y;
    Dimension w, h;
    Widget child;

    if (((XfwfFrameWidget)self)->composite.num_children == 0) return;
    ((XfwfFrameWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
    child = ((XfwfFrameWidget)self)->composite.children[0];
    w -= 2 * ((XfwfFrameWidget)child)->core.border_width;
    h -= 2 * ((XfwfFrameWidget)child)->core.border_width;
    XtConfigureWidget(child, x, y, w, h, ((XfwfFrameWidget)child)->core.border_width);
}
/*ARGSUSED*/static void change_managed(Widget self)
{
    XtWidgetGeometry request2, reply2;
    XtGeometryResult result;
    Widget child;
    Position x, y;
    Dimension w, h;

    if (((XfwfFrameWidget)self)->composite.num_children == 0) return;
    ((XfwfFrameWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
    child = ((XfwfFrameWidget)self)->composite.children[0];
    request2.request_mode = CWWidth | CWHeight;
    request2.width = ((XfwfFrameWidget)child)->core.width + ((XfwfFrameWidget)self)->core.width - w;
    request2.height = ((XfwfFrameWidget)child)->core.height + ((XfwfFrameWidget)self)->core.height - h;
    result = XtMakeGeometryRequest(self, &request2, &reply2);
    ((XfwfFrameWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
    w -= 2 * ((XfwfFrameWidget)child)->core.border_width;
    h -= 2 * ((XfwfFrameWidget)child)->core.border_width;
    XtConfigureWidget(child, x, y, w, h, ((XfwfFrameWidget)child)->core.border_width);
}
/*ARGSUSED*/void XfwfDrawFrame(Widget self, int x, int y, int w, int h, FrameType tp, int t, GC lightgc, GC darkgc)
{
    XPoint tlPoints[7], brPoints[7];

    if (t == 0) return;
    switch (tp) {
    case XfwfRaised:
    case XfwfSunken:
	tlPoints[0].x = x;		tlPoints[0].y = y;
	tlPoints[1].x = x + w;		tlPoints[1].y = y;
	tlPoints[2].x = x + w - t;	tlPoints[2].y = y + t;
	tlPoints[3].x = x + t;		tlPoints[3].y = y + t;
	tlPoints[4].x = x + t;		tlPoints[4].y = y + h - t;
	tlPoints[5].x = x;		tlPoints[5].y = y + h;
	tlPoints[6].x = x;		tlPoints[6].y = y;
	brPoints[0].x = x + w;		brPoints[0].y = y + h;
	brPoints[1].x = x;		brPoints[1].y = y + h;
	brPoints[2].x = x + t;		brPoints[2].y = y + h - t;
	brPoints[3].x = x + w - t;	brPoints[3].y = y + h - t;
	brPoints[4].x = x + w - t;	brPoints[4].y = y + t;
	brPoints[5].x = x + w;		brPoints[5].y = y;
	brPoints[6].x = x + w;		brPoints[6].y = y + h;
	if (tp == XfwfSunken) {
	    XFillPolygon(XtDisplay(self), XtWindow(self),
			 darkgc, tlPoints, 7, Nonconvex, CoordModeOrigin);
	    XFillPolygon(XtDisplay(self), XtWindow(self),
			 lightgc, brPoints, 7, Nonconvex, CoordModeOrigin);
	} else {
	    XFillPolygon(XtDisplay(self), XtWindow(self),
			 lightgc, tlPoints, 7, Nonconvex, CoordModeOrigin);
	    XFillPolygon(XtDisplay(self), XtWindow(self),
			 darkgc, brPoints, 7, Nonconvex, CoordModeOrigin);
	}
	break;
    case XfwfLedged:
	XfwfDrawFrame(self, x, y, w, h, XfwfRaised, t/2, lightgc, darkgc);
	XfwfDrawFrame(self, x+t/2, y+t/2, w-2*(int)(t/2), h-2*(int)(t/2),
		  XfwfSunken, t/2, lightgc, darkgc);
	break;
    case XfwfChiseled:
	XfwfDrawFrame(self, x, y, w, h, XfwfSunken, t/2, lightgc, darkgc);
	XfwfDrawFrame(self, x+t/2, y+t/2, w-2*(int)(t/2), h-2*(int)(t/2),
		  XfwfRaised, t/2, lightgc, darkgc);
	break;
    }

}
/*ARGSUSED*/Boolean  cvtStringToFrameType(Display *display, XrmValuePtr args, Cardinal *num_args, XrmValuePtr from, XrmValuePtr to, XtPointer *converter_data)
{
    String s = (String) from->addr;

    if (*num_args != 0)
	XtAppErrorMsg(XtDisplayToApplicationContext(display),
		      "cvtStringToFrameType", "wrongParameters",
		      "XtToolkitError",
		      "String to frame type conversion needs no arguments",
		      (String*) NULL, (Cardinal*) NULL);

    if (XmuCompareISOLatin1(s, "raised") == 0) done(FrameType, XfwfRaised);
    if (XmuCompareISOLatin1(s, "sunken") == 0) done(FrameType, XfwfSunken);
    if (XmuCompareISOLatin1(s, "chiseled") == 0) done(FrameType, XfwfChiseled);
    if (XmuCompareISOLatin1(s, "ledged") == 0) done(FrameType, XfwfLedged);
    XtDisplayStringConversionWarning(display, s, XtRFrameType);
    done(FrameType, XfwfRaised);
}
/*ARGSUSED*/Boolean  cvtFrameTypeToString(Display *display, XrmValuePtr args, Cardinal *num_args, XrmValuePtr from, XrmValuePtr to, XtPointer *converter_data)
{
    if (*num_args != 0)
	XtAppErrorMsg(XtDisplayToApplicationContext(display),
		      "cvtFrameTypeToString", "wrongParameters",
		      "XtToolkitError",
		      "Fframe type to String conversion needs no arguments",
		      (String*) NULL, (Cardinal*) NULL);
    switch (*(FrameType*)from->addr) {
    case XfwfRaised: done(String, "raised");
    case XfwfSunken: done(String, "sunken");
    case XfwfChiseled: done(String, "chiseled");
    case XfwfLedged: done(String, "ledged");
    default: XtError("Illegal FrameType");
    }
}
/*ARGSUSED*/Boolean  cvtStringToShadowScheme(Display *display, XrmValuePtr args, Cardinal *num_args, XrmValuePtr from, XrmValuePtr to, XtPointer *converter_data)
{
    String s = (String) from->addr;

    if (*num_args != 0)
	XtAppErrorMsg(XtDisplayToApplicationContext(display),
		      "cvtStringToShadowScheme", "wrongParameters",
		      "XtToolkitError",
		      "String to shadow scheme conversion needs no arguments",
		      (String*) NULL, (Cardinal*) NULL);

    if (XmuCompareISOLatin1(s, "auto")==0) done(ShadowScheme, XfwfAuto);
    if (XmuCompareISOLatin1(s, "color")==0) done(ShadowScheme, XfwfColor);
    if (XmuCompareISOLatin1(s, "stipple")==0) done(ShadowScheme, XfwfStipple);
    XtDisplayStringConversionWarning(display, s, XtRShadowScheme);
    done(ShadowScheme, XfwfAuto);
}
/*ARGSUSED*/Boolean  cvtShadowSchemeToString(Display *display, XrmValuePtr args, Cardinal *num_args, XrmValuePtr from, XrmValuePtr to, XtPointer *converter_data)
{
    if (*num_args != 0)
	XtAppErrorMsg(XtDisplayToApplicationContext(display),
		      "cvtShadowSchemeToString", "wrongParameters",
		      "XtToolkitError",
		      "Shadow scheme to String conversion needs no arguments",
		      (String*) NULL, (Cardinal*) NULL);

    switch (*(ShadowScheme*)from->addr) {
    case XfwfAuto: done(String, "auto");
    case XfwfColor: done(String, "color");
    case XfwfStipple: done(String, "stipple");
    default: XtError("Illegal ShadowScheme");
    }
}
