--- ncbi-vdb/build/env.cmake.orig	2023-07-10 16:13:36 UTC
+++ ncbi-vdb/build/env.cmake
@@ -75,9 +75,15 @@ set(CMAKE_CXX_EXTENSIONS OFF)
 if ( ${CMAKE_SYSTEM_NAME} STREQUAL  "Darwin" )
     set(OS "mac")
     set(SHLX "dylib")
+elseif ( ${CMAKE_SYSTEM_NAME} STREQUAL  "FreeBSD" )
+    set(OS "bsd")
+    set(SHLX "so")
 elseif ( ${CMAKE_SYSTEM_NAME} STREQUAL  "Linux" )
     set(OS "linux")
     set(SHLX "so")
+elseif ( ${CMAKE_SYSTEM_NAME} STREQUAL  "NetBSD" )
+    set(OS "bsd")
+    set(SHLX "so")
 elseif ( ${CMAKE_SYSTEM_NAME} STREQUAL  "Windows" )
     set(OS "windows")
 else()
@@ -99,6 +105,8 @@ elseif ( ${_system_processor} STREQUAL "x86_64")
     set(ARCH "x86_64")
 elseif ( ${_system_processor} STREQUAL "AMD64")
     set(ARCH "x86_64")
+elseif ( ${_system_processor} STREQUAL "amd64")
+    set(ARCH "x86_64")
 else ()
     message ( FATAL_ERROR "unknown architecture " ${_system_processor})
 endif ()
@@ -110,6 +118,9 @@ if ( "mac" STREQUAL ${OS} )
     set(CMAKE_CXX_ARCHIVE_CREATE "<CMAKE_AR> Scr <TARGET> <LINK_FLAGS> <OBJECTS>")
     set(CMAKE_C_ARCHIVE_FINISH   "<CMAKE_RANLIB> -no_warning_for_no_symbols -c <TARGET>")
     set(CMAKE_CXX_ARCHIVE_FINISH "<CMAKE_RANLIB> -no_warning_for_no_symbols -c <TARGET>")
+elseif( "bsd" STREQUAL ${OS} )
+    add_compile_definitions( BSD UNIX )
+    set( LMCHECK "" )
 elseif( "linux" STREQUAL ${OS} )
     add_compile_definitions( LINUX UNIX )
     set( LMCHECK -lmcheck )
@@ -241,6 +252,9 @@ endif()
 
 if ( "mac" STREQUAL ${OS} )
     include_directories(interfaces/os/mac)
+    include_directories(interfaces/os/unix)
+elseif( "bsd" STREQUAL ${OS} )
+    include_directories(interfaces/os/bsd)
     include_directories(interfaces/os/unix)
 elseif( "linux" STREQUAL ${OS} )
     include_directories(interfaces/os/linux)
