
//  (C) Copyright Edward Diener 2011-2015
//  Use, modification and distribution are subject to the Boost Software License,
//  Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt).

#include <boost/vmd/elem.hpp>
#include <boost/vmd/is_empty.hpp>
#include <boost/detail/lightweight_test.hpp>
#include <boost/preprocessor/seq/elem.hpp>
#include <boost/preprocessor/tuple/elem.hpp>

int main()
  {
  
#if BOOST_PP_VARIADICS

  #define BOOST_VMD_REGISTER_ggh (ggh)
  #define BOOST_VMD_REGISTER_dvd (dvd)
  
  #define ANIDENTIFIER ggh
  #define ANIDENTIFIER2 dvd
  #define ANUMBER 249
  #define ANUMBER2 17
  #define ASEQ (25)(26)(27)
  #define ATUPLE (0,1,2,3,((a,b))((c,d))((e))((f,g,h)))
  #define ALIST (0,(1,(2,(3,BOOST_PP_NIL))))
  #define ANARRAY (3,(a,b,38))
  #define ANARRAY2 (5,(c,d,133,22,15))
  #define ASEQUENCE ANUMBER ALIST ATUPLE ANIDENTIFIER ANARRAY ASEQ
  #define ASEQUENCE2 ANIDENTIFIER2 ANARRAY2 ASEQ ALIST ANUMBER ATUPLE
  #define ASEQUENCE3 ASEQ ANUMBER2 ATUPLE
  #define ASEQUENCE4
  
  #define AN_ARRAY_PLUS (4,(mmf,34,^^,!)) 456
  #define PLUS_ANARRAY yyt (2,(j,ii%))
  #define JDATA ggh
  #define KDATA (2,(a,b)) name
  #define A_SEQ ((1,(25)) 7)((1,(26)) 8)((1,(27)) 9)
  
#if !BOOST_VMD_MSVC_V8
  #define ANARRAY_EMPTY (0,())
  #define AN_EMPTY_ARRAY_PLUS (0,()) 46
  #define ASEQUENCE5 ASEQ ANUMBER ANARRAY_EMPTY ATUPLE
#endif

  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_VMD_ELEM(0,ANIDENTIFIER,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY)));
  BOOST_TEST_EQ(BOOST_PP_SEQ_ELEM(0,BOOST_VMD_ELEM(4,ASEQUENCE,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY)),25);
  BOOST_TEST(!BOOST_VMD_IS_EMPTY(BOOST_VMD_ELEM(1,ASEQUENCE2,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY)));
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_VMD_ELEM(1,ASEQUENCE3,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY)));
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_VMD_ELEM(0,ASEQUENCE4,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY)));
  
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_VMD_ELEM(0,anything,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY)));
  BOOST_TEST_EQ(BOOST_VMD_ELEM(0,AN_ARRAY_PLUS,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY),456);
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_VMD_ELEM(0,PLUS_ANARRAY,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY)));
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_VMD_ELEM(0,JDATA,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY)));
  BOOST_TEST(!BOOST_VMD_IS_EMPTY(BOOST_VMD_ELEM(0,KDATA,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY)));
  BOOST_TEST_EQ(BOOST_VMD_ELEM(0,BOOST_PP_SEQ_ELEM(1,A_SEQ),BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY),8);

#if !BOOST_VMD_MSVC_V8
  BOOST_TEST_EQ(BOOST_PP_TUPLE_ELEM(1,BOOST_VMD_ELEM(2,ASEQUENCE5,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY)),1);
  BOOST_TEST_EQ(BOOST_VMD_ELEM(0,AN_EMPTY_ARRAY_PLUS,BOOST_VMD_RETURN_ONLY_AFTER,BOOST_VMD_TYPE_ARRAY),46);
#endif

#else

BOOST_ERROR("No variadic macro support");
  
#endif

  return boost::report_errors();
  
  }
