/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*- */
/*
 * Copyright © 2016 – 2017 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#if !defined (__GOA_BACKEND_INSIDE_GOA_BACKEND_H__) && !defined (GOA_BACKEND_COMPILATION)
#error "Only <goabackend/goabackend.h> can be included directly."
#endif

#ifndef __GOA_OAUTH2_PROVIDER_WEB_EXTENSION_H__
#define __GOA_OAUTH2_PROVIDER_WEB_EXTENSION_H__

#include <goabackend/goaoauth2provider.h>
#include <webkitdom/webkitdom.h>

G_BEGIN_DECLS

gboolean     goa_oauth2_provider_is_deny_node                 (GoaOAuth2Provider             *provider,
                                                               WebKitDOMNode                 *node);
gboolean     goa_oauth2_provider_is_identity_node             (GoaOAuth2Provider             *provider,
                                                               WebKitDOMHTMLInputElement     *element);
gboolean     goa_oauth2_provider_is_password_node             (GoaOAuth2Provider             *provider,
                                                               WebKitDOMHTMLInputElement     *element);

G_END_DECLS

#endif /* __GOA_OAUTH2_PROVIDER_WEB_EXTENSION_H__ */
