; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -loop-reduce -S %s | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx"

declare void @use(i64)
declare void @use.i32(i32)
declare void @use.i8(i8)

define i32 @test_pr38847() {
; CHECK-LABEL: define i32 @test_pr38847() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[LSR_IV1:%.*]] = phi i32 [ [[LSR_IV_NEXT2:%.*]], [[LOOP]] ], [ 1, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[LSR_IV:%.*]] = phi i64 [ [[LSR_IV_NEXT:%.*]], [[LOOP]] ], [ 1, [[ENTRY]] ]
; CHECK-NEXT:    [[LSR_IV_NEXT2]] = add nsw i32 [[LSR_IV1]], -1
; CHECK-NEXT:    [[LSR:%.*]] = trunc i32 [[LSR_IV_NEXT2]] to i8
; CHECK-NEXT:    call void @use(i64 [[LSR_IV]])
; CHECK-NEXT:    [[LSR_IV_NEXT]] = add nsw i64 [[LSR_IV]], -1
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sgt i8 [[LSR]], -1
; CHECK-NEXT:    br i1 [[CMP2]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[TMP0:%.*]] = udiv i32 [[LSR_IV_NEXT2]], 9
; CHECK-NEXT:    [[TMP1:%.*]] = mul nuw i32 [[TMP0]], 9
; CHECK-NEXT:    [[TMP2:%.*]] = sub i32 [[LSR_IV_NEXT2]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[TMP2]]
;
entry:
  br label %loop

loop:
  %iv = phi i8 [ 1, %entry ], [ %iv.next, %loop ]
  %iv.next = add nsw i8 %iv, -1
  %ext = zext i8 %iv to i64
  call void @use(i64 %ext)
  %cmp2 = icmp sgt i8 %iv.next, -1
  br i1 %cmp2, label %loop, label %exit

exit:
  %sext = sext i8 %iv.next to i32
  %rem = urem i32 %sext, 9
  ret i32 %rem
}

define i64 @test_pr58039() {
; CHECK-LABEL: define i64 @test_pr58039() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[LSR_IV:%.*]] = phi i64 [ [[LSR_IV_NEXT:%.*]], [[LOOP]] ], [ -4294967213, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i64 [[IV]] to i32
; CHECK-NEXT:    call void @use.i32(i32 [[TMP2]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; CHECK-NEXT:    [[LSR_IV_NEXT]] = add nsw i64 [[LSR_IV]], 4294967295
; CHECK-NEXT:    br i1 false, label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[TMP0:%.*]] = udiv i64 [[LSR_IV_NEXT]], 12
; CHECK-NEXT:    [[TMP1:%.*]] = mul nuw nsw i64 [[TMP0]], 12
; CHECK-NEXT:    [[TMP2:%.*]] = add nuw nsw i64 [[TMP1]], 4294967221
; CHECK-NEXT:    [[TMP3:%.*]] = add i64 [[TMP2]], [[IV_NEXT]]
; CHECK-NEXT:    [[TMP:%.*]] = trunc i64 [[TMP3]] to i32
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult i32 [[TMP]], 32
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[CMP3]], i64 0, i64 [[IV_NEXT]]
; CHECK-NEXT:    ret i64 [[SPEC_SELECT]]
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %iv1 = phi i32 [ -74, %entry ], [ %iv1.next, %loop ]
  %iv2 = phi i32 [ 83, %entry ], [ %iv2.next, %loop ]
  %iv3 = phi i32 [ 0, %entry ], [ %iv3.next, %loop ]
  call void @use.i32(i32 %iv3)
  %iv.next = add nuw nsw i64 %iv, 1
  %iv1.next = add nuw nsw i32 %iv1, 1
  %iv2.next = add nsw i32 %iv2, -1
  %iv3.next = add nuw nsw i32 %iv3, 1
  br i1 false, label %loop, label %exit

exit:
  %i2 = udiv i32 %iv2.next, 12
  %i5 = mul nuw nsw i32 %i2, 12
  %i6 = add i32 %iv1, %i5
  %cmp3 = icmp ult i32 %i6, 32
  %spec.select = select i1 %cmp3, i64 0, i64 %iv.next
  ret i64 %spec.select
}

define i32 @test_pr62852() {
; CHECK-LABEL: define i32 @test_pr62852() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[LSR_IV1:%.*]] = phi i64 [ [[LSR_IV_NEXT2:%.*]], [[LOOP]] ], [ -1, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[LSR_IV:%.*]] = phi i64 [ [[LSR_IV_NEXT:%.*]], [[LOOP]] ], [ 2, [[ENTRY]] ]
; CHECK-NEXT:    [[IV_1:%.*]] = phi i32 [ 1, [[ENTRY]] ], [ [[DEC_1:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = add i64 [[LSR_IV1]], 1
; CHECK-NEXT:    [[DEC_1]] = add nsw i32 [[IV_1]], -1
; CHECK-NEXT:    call void @use(i64 [[TMP0]])
; CHECK-NEXT:    [[LSR_IV_NEXT]] = add nsw i64 [[LSR_IV]], -1
; CHECK-NEXT:    [[TMP:%.*]] = trunc i64 [[LSR_IV_NEXT]] to i32
; CHECK-NEXT:    [[LSR_IV_NEXT2]] = add nsw i64 [[LSR_IV1]], 1
; CHECK-NEXT:    [[CMP6_1:%.*]] = icmp sgt i32 [[TMP]], 0
; CHECK-NEXT:    br i1 [[CMP6_1]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    call void @use(i64 [[LSR_IV_NEXT]])
; CHECK-NEXT:    call void @use(i64 [[LSR_IV_NEXT2]])
; CHECK-NEXT:    [[TMP1:%.*]] = udiv i32 [[DEC_1]], 53
; CHECK-NEXT:    [[TMP2:%.*]] = mul nuw i32 [[TMP1]], 53
; CHECK-NEXT:    [[TMP3:%.*]] = sub i32 [[DEC_1]], [[TMP2]]
; CHECK-NEXT:    ret i32 [[TMP3]]
;
entry:
  br label %loop

loop:
  %iv.1 = phi i32 [ 1, %entry ], [ %dec.1, %loop ]
  %iv.2 = phi i64 [ 0, %entry ], [ %inc.1, %loop ]
  %inc.1 = add nsw i64 %iv.2, 1
  %dec.1 = add nsw i32 %iv.1, -1
  call void @use(i64 %iv.2)
  %cmp6.1 = icmp sgt i32 %iv.1, 0
  br i1 %cmp6.1, label %loop, label %exit

exit:
  %iv.1.ext = zext i32 %iv.1 to i64
  call void @use(i64 %iv.1.ext)
  call void @use(i64 %iv.2)
  %rem = urem i32 %dec.1, 53
  ret i32 %rem
}

define i64 @test_normalization_failure_in_any_extend(ptr %i, i64 %i1, i8 %i25) {
; CHECK-LABEL: define i64 @test_normalization_failure_in_any_extend
; CHECK-SAME: (ptr [[I:%.*]], i64 [[I1:%.*]], i8 [[I25:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_1_HEADER:%.*]]
; CHECK:       loop.1.header:
; CHECK-NEXT:    [[IV_1:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_1_NEXT:%.*]], [[LOOP_1_LATCH:%.*]] ]
; CHECK-NEXT:    [[IV_2:%.*]] = phi i64 [ [[I1]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP_1_LATCH]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = add i64 [[IV_2]], 2
; CHECK-NEXT:    br label [[LOOP_2:%.*]]
; CHECK:       loop.2:
; CHECK-NEXT:    [[LSR_IV:%.*]] = phi i32 [ [[LSR_IV_NEXT:%.*]], [[LOOP_2]] ], [ 2, [[LOOP_1_HEADER]] ]
; CHECK-NEXT:    [[LSR_IV_NEXT]] = add nsw i32 [[LSR_IV]], -1
; CHECK-NEXT:    [[C_1:%.*]] = icmp sgt i32 [[LSR_IV_NEXT]], 0
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_2]], label [[LOOP_3_PREHEADER:%.*]]
; CHECK:       loop.3.preheader:
; CHECK-NEXT:    br label [[LOOP_3:%.*]]
; CHECK:       loop.3:
; CHECK-NEXT:    [[LSR_IV5:%.*]] = phi i64 [ 0, [[LOOP_3_PREHEADER]] ], [ [[LSR_IV_NEXT6:%.*]], [[LOOP_3]] ]
; CHECK-NEXT:    [[LSR_IV1:%.*]] = phi i64 [ 2, [[LOOP_3_PREHEADER]] ], [ [[LSR_IV_NEXT2:%.*]], [[LOOP_3]] ]
; CHECK-NEXT:    [[IV_5:%.*]] = phi i32 [ [[IV_5_NEXT:%.*]], [[LOOP_3]] ], [ 1, [[LOOP_3_PREHEADER]] ]
; CHECK-NEXT:    [[IV_5_NEXT]] = add nsw i32 [[IV_5]], -1
; CHECK-NEXT:    [[LSR:%.*]] = trunc i32 [[IV_5_NEXT]] to i8
; CHECK-NEXT:    [[LSR_IV_NEXT2]] = add nsw i64 [[LSR_IV1]], -1
; CHECK-NEXT:    [[TMP:%.*]] = trunc i64 [[LSR_IV_NEXT2]] to i32
; CHECK-NEXT:    [[LSR_IV_NEXT6]] = add nsw i64 [[LSR_IV5]], -1
; CHECK-NEXT:    [[C_2:%.*]] = icmp sgt i32 [[TMP]], 0
; CHECK-NEXT:    br i1 [[C_2]], label [[LOOP_3]], label [[LOOP_1_LATCH]]
; CHECK:       loop.1.latch:
; CHECK-NEXT:    [[IV_1_NEXT]] = add nuw nsw i32 [[IV_1]], 1
; CHECK-NEXT:    [[TMP1]] = sub i64 [[TMP0]], [[LSR_IV_NEXT6]]
; CHECK-NEXT:    [[C_3:%.*]] = icmp eq i32 [[IV_1_NEXT]], 8
; CHECK-NEXT:    br i1 [[C_3]], label [[EXIT:%.*]], label [[LOOP_1_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    call void @use.i32(i32 [[IV_5_NEXT]])
; CHECK-NEXT:    [[TMP2:%.*]] = add i64 [[IV_2]], 1
; CHECK-NEXT:    [[TMP3:%.*]] = sub i64 [[TMP2]], [[LSR_IV_NEXT6]]
; CHECK-NEXT:    call void @use(i64 [[TMP3]])
; CHECK-NEXT:    call void @use(i64 [[LSR_IV_NEXT2]])
; CHECK-NEXT:    [[TMP4:%.*]] = udiv i32 [[IV_5_NEXT]], 53
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i8
; CHECK-NEXT:    [[TMP6:%.*]] = mul i8 [[TMP5]], 53
; CHECK-NEXT:    [[TMP7:%.*]] = sub i8 [[LSR]], [[TMP6]]
; CHECK-NEXT:    call void @use.i8(i8 [[TMP7]])
; CHECK-NEXT:    [[I26:%.*]] = xor i8 [[I25]], 5
; CHECK-NEXT:    [[I27:%.*]] = zext i8 [[I26]] to i64
; CHECK-NEXT:    ret i64 [[I27]]
;
entry:
  br label %loop.1.header

loop.1.header:
  %iv.1 = phi i32 [ 0, %entry ], [ %iv.1.next, %loop.1.latch ]
  %iv.2 = phi i64 [ %i1, %entry ], [ %iv.6.next, %loop.1.latch ]
  br label %loop.2

loop.2:
  %iv.3 = phi i32 [ 1, %loop.1.header ], [ %iv.3.next, %loop.2 ]
  %iv.4 = phi i64 [ %iv.2, %loop.1.header ], [ %iv.4.next, %loop.2 ]
  %iv.4.next = add nsw i64 %iv.4, 1
  %iv.3.next = add nsw i32 %iv.3, -1
  %c.1 = icmp sgt i32 %iv.3, 0
  br i1 %c.1, label %loop.2, label %loop.3

loop.3:
  %iv.5 = phi i32 [ 1, %loop.2 ], [ %iv.5.next, %loop.3 ]
  %iv.6 = phi i64 [ %iv.4.next, %loop.2 ], [ %iv.6.next, %loop.3 ]
  %iv.6.next = add nsw i64 %iv.6, 1
  %iv.5.next = add nsw i32 %iv.5, -1
  %c.2 = icmp sgt i32 %iv.5, 0
  br i1 %c.2, label %loop.3, label %loop.1.latch

loop.1.latch:
  %iv.1.next = add nuw nsw i32 %iv.1, 1
  %c.3 = icmp eq i32 %iv.1.next, 8
  br i1 %c.3, label %exit, label %loop.1.header

exit:
  call void @use.i32(i32 %iv.5.next)
  %i21 = zext i32 %iv.5 to i64
  call void @use(i64 %iv.6)
  call void @use(i64 %i21)
  %i22 = urem i32 %iv.5.next, 53
  %i23 = trunc i32 %i22 to i8
  call void @use.i8(i8 %i23)
  %i26 = xor i8 %i25, 5
  %i27 = zext i8 %i26 to i64
  ret i64 %i27
}
