// Copyright (C) 2020 Rick Waldron. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-ecmascript-standard-built-in-objects
description: >
  The AsyncArrowFunction constructor implements [[Construct]]
info: |
  IsConstructor ( argument )

  The abstract operation IsConstructor takes argument argument (an ECMAScript language value).
  It determines if argument is a function object with a [[Construct]] internal method.
  It performs the following steps when called:

  If Type(argument) is not Object, return false.
  If argument has a [[Construct]] internal method, return true.
  Return false.
includes: [isConstructor.js, hidden-constructors.js]
features: [Reflect.construct]
---*/

assert.sameValue(isConstructor(AsyncArrowFunction), true, 'isConstructor(AsyncArrowFunction) must return true');
new AsyncArrowFunction();
  

reportCompare(0, 0);
