Skia Graphics Library
=====================

Skia is an open source 2D graphics library which provides common APIs that work
across a variety of hardware and software platforms.  It serves as the graphics
engine for Google Chrome and Chrome OS, Android, Mozilla Firefox and Firefox
OS, and many other products.

Skia is sponsored and managed by Google, but is available for use by anyone
under the BSD Free Software License.  While engineering of the core components
is done by the Skia development team, we consider contributions from any
source.

Showcase
--------

Click on any image below to see the source code that generated the image.
<table>
  <tr><th>Shapes</th><th>Bézier Curves</th></tr>
  <tr>
    <td>
      <a href="https://fiddle.skia.org/c/95552fd2a4b8acacc05a63825cca854e"><img src="https://fiddle.skia.org/i/95552fd2a4b8acacc05a63825cca854e_raster.png"></a>
    </td>
    <td>
      <a href="https://fiddle.skia.org/c/79928f82141e6f76ae1ea30c41d80a17"><img src="https://fiddle.skia.org/i/79928f82141e6f76ae1ea30c41d80a17_raster.png"></a>
    </td>
  </tr>

  <tr><th>Translations and Rotations</th><th>Text Rendering</th></tr>
  <tr>
    <td>
      <a href="https://fiddle.skia.org/c/c6ba5c36dc535655a66c05f3149a54c3"><img src="https://fiddle.skia.org/i/c6ba5c36dc535655a66c05f3149a54c3_raster.png"></a>
    </td>
    <td>
      <a href="https://fiddle.skia.org/c/ec367821b22171bdc66f36a2e73ee92b"><img src="https://fiddle.skia.org/i/ec367821b22171bdc66f36a2e73ee92b_raster.png"></a>
    </td>
  </tr>

  <tr><th>Discrete Path Effects</th><th>Composed Path Effects</th></tr>
  <tr>
    <td>
      <a href="https://fiddle.skia.org/c/297da5f57b71c91b5a3bab4db9673cc4"><img src="https://fiddle.skia.org/i/297da5f57b71c91b5a3bab4db9673cc4_raster.png" alt=""></a>
    </td>
    <td>
      <a href="https://fiddle.skia.org/c/df5928f1f3173878e5f647a2dbb2d250"><img src="https://fiddle.skia.org/i/df5928f1f3173878e5f647a2dbb2d250_raster.png" alt=""></a>
    </td>
  </tr>
  <tr><th>Sum Path Effects</th><th>Shaders</th></tr>
  <tr>
    <td>
      <a href="https://fiddle.skia.org/c/2cc23c611102ba01616c775ebc4308d6"><img src="https://fiddle.skia.org/i/2cc23c611102ba01616c775ebc4308d6_raster.png" alt=""></a>
    </td>
    <td>
      <a href="https://fiddle.skia.org/c/0261e010db41116bc1e1c045900e0dc3"> <img src="https://fiddle.skia.org/i/0261e010db41116bc1e1c045900e0dc3_raster.png"></a>
    </td>
  </tr>
</table>

Roadmap
-------
For a look at high level items we have on tap the next 6-12 months, view our
roadmap [here](https://docs.google.com/document/d/1jb9XcGpi0EpvJcxttHjo5OkIHljRRxAEfIhoxRUut4I).
Note it is a living document that changes based on the requirements of our users.

Recent Highlights
-----------------
See a summary of recent changes to the library [here](https://docs.google.com/a/skia.org/document/d/1Q4-YN8wDY9Q3L7gkqOJmmCLM73dj3tr9epUHL1vMZm4).

