<!--
SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
SPDX-License-Identifier: BSD-2-Clause
-->

# Changelog

All notable changes to the prips project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [1.2.2] - 2025-04-12

### Fixes

* C implementation:
    - make the exclusion handling more robust
* Test suite:
    - make the `05-except` test actually test multiple patterns

### Additions

* Add a `.gitignore` file.
* Rust implementation:
    - implement the `-e exclude-pattern` command-line option
* Documentation:
    - switch to Markdown-based MkDocs
    - convert the changelog to the "Keep a Changelog" format

### Other changes

* Rust implementation:
    - make the modules private; `prips` is not a library crate
    - use the `anyhow` and `thiserror` crates instead of `expect-exit` and `quick-error`
    - add the `run-clippy.sh` tool to run the Rust linter
    - minor refactoring and fixes
    - also keep the `Cargo.lock` file under version control
* Test suite:
    - allow the tests to be run from any directory

## [1.2.0] - 2021-12-18

### Fixes

* Fix a bug in handling a range that ends at 255.255.255.255;
  thanks to [Tassilo Philipp][contrib-tphilipp] for
  reporting it!
* Fix a bug in the CIDR (-c) output when the specified addresses
  differ even in their very first bit.
* Allow 255.255.255.255 to be specified now that we use
  inet_pton() for parsing the input addresses.

### Additions

* Add a test for multiple -e options specified.
* Add a test for the CIDR output when the -c option is specified.
* Add a test for the --features option if the feature-check tool is
  installed.
* Add a Rust implementation of prips.
* Add "implemented in ..." features: prips-impl-c or prips-impl-rust.
* Declare the "exclude" feature in the C implementation and check for
  that in the corresponding test.

## [1.1.1] - 2018-12-25

### Fixes

* Fix a bug in the interplay between the -i (increment) and
  -e (exclude) handling and add the 05-except test; thanks to
  [Tassilo Philipp][contrib-tphilipp] for reporting
  the bug!

## [1.1.0] - 2018-05-14

### Fixes

* Remove a stray blank line in this change log.

### Additions

* Add the -h, --help, --version, and --features options.

## [1.0.2] - 2018-01-15

### Fixes

* Allow the Makefile install commands to be overridden.

## [1.0.1] - 2017-01-03

### Fixes

* Documentation fixes:
    - the CIDR notation requires all four octets of the prefix IP address
      (reported by Kovács András)
    - the options should be placed before the positional arguments
    - remove the carriage-return characters from the -v (version) output
      and replace them with C string concatenation
    - use $(...) instead of \`...\` for shell command substitution
    - always quote shell variables and parameters as good practice
* Do not output the program name (or path) twice in error messages.
* Use errx(3) to report errors in two more places.
* Fix the 01-cidr test's checks for the prips exit code!
* Correct two typographical errors.

### Additions

* Use automake's tap-functions.sh for the test suite.
* Add the 02-range test for address ranges.
* Add the 03-skip test for specifying the increment value.
* Add the 04-format test for specifying the output format.

## [1.0.0] - 2016-04-11

### Fixes

* Remove -Wsystem-headers from the Makefile list of compiler flags;
  it seems to expose a 'long long'-related bug in GNU libc.
* Replace the _GNU_SOURCE definition with the more appropriate
  _POSIX_C_SOURCE and _XOPEN_SOURCE ones and move them to the Makefile.
* Refactor add_offset() a bit so that the /0 and /32 CIDR masks are
  handled correctly.  Reported by: [Sebastian Posner][contrib-sposner]
* Add a .PHONY declaration for the, well, phony Makefile targets.

### Additions

* Add the beginnings of a test suite.
* Add an "install" target.

### Other changes

* Use the C99 "bool" type.
* Use C99 syntax to minimize the scope and mutability of some variables.
* Use the errx(3) function to report errors.

## [0.9.9] - 2011-03-10

### Fixes

* Fix a getopt() handling bug in main.c that could lead to an infinite
  loop on architectures where char is unsigned.

## [0.9.8] - 2011-03-01

### Fixes

* Fix some grammatical constructions in the manual page and
  the usage message.

### Other changes

* Bump the year on my copyright notice on the main.c and prips.1 files.

## [0.9.7] - 2010-06-23

### Fixes

* Made the Makefile respect CPPFLAGS and LDFLAGS in the environment.

### Other changes

* Bump the year on my copyright notice on the Makefile and main.c files.

## [0.9.6] - 2009-04-04

### Fixes

* Seems I was a bit too overzealous when removing unused functions:
  it turns out that the set_bits_from_right(), count_bits(), and
  get_class() functions are actually used by ipsc, which uses
  the prips source to build

## [0.9.5] - 2009-03-27

### Changes

* Peter Pentchev took over the package from Daniel Kelly
* Added a $(RM) definition in the Makefile so the "clean"
  target actually works
* Fixed the format of two multiline strings in main.c
  (Joshua Kwan)
* Added an include of <string.h> for the declaration of strlen()
  (Joshua Kwan)
* Fixed a variable type so prips works on 64-bit platforms
  (Robert S. Edmonds)
* Updated and sorted the CONTRIBUTORS file
* Made variable assignments in the Makefile conditional to allow
  users (and packagers) to override the compiler program, flags, etc.
* Switched over to using the POSIX uint32_t type if available
* Fixed a couple of C compiler signedness warnings
* Got rid of the use of pow(3) when a simple shift would suffice!
* Removed the unused _spil() function from except.c and
  get_bits_from_right(), count_on_bits(), and get_class() from prips.c
* Made the fill() function in except.c and the usage() and get_format()
  functions in main.c static
* Constified a couple of strings
* Added a lot of C compiler warning flags to the Makefile
* Made get_format() a bit more flexible
* Fixed a variable type in cidrize(), removing two unneeded casts
* Added the GPL-2 file containing version 2 of the General Public License
  and slapped the required blurb on all source files
* Added copyright notices for Daniel Kelly and me
* Added the prips.1 manual page from the Debian package of prips
  (Juan Alvarez)
* Converted the manual page to mdoc format and fleshed it out a bit
* Added the -h option to the usage message
* Reflowed the README file to a 80-column-friendly format
* Corrected the portability information in the README file
* Changed the FreeBSD-or-NetBSD check to a more proper POSIX one and
  assume we are building on a POSIX-compatible system by default
* Added a _GNU_SOURCE definition for snprintf() and opterr/optind on
  modern Linux systems

## [0.9.4]

### Changes

* Fixed a compile problem on FreeBSD, and
  probably on other platforms as well 
  (Jeremy Shaffner)
* updated the CONTRIBUTORS file

## 0.9.3

### Changes

* Compiles on NetBSD (David Wiggins)
* Fixed denumberize() and numberize() so that there are no 
  assumptions about byte order (Matthew Flanagan)
* Removed denboize() because it did the same thing as
  ntohl() but in an unportable way

## 0.9.2

### Changes

* Added IPQUAD() macro.  It seems to speed up the printing of 
  dotted decimal IPs.  It's slightly faster than denumberize() 
  and good in situations where denumberize() doesn't work (due
  to the static buffer).
* Minor code formatting

## 0.9.1

### Changes

* new versioning
* should compile on FreeBSD (Mitch)
* fixed a compiler warning in denumberize()

## 0.9a

### Changes

* prips no longer accepts addresses where one of the elements
  (octets) is greater than 255 or less than zero. (Sara Pickett)
* prips no longer accepts CIDR blocks where the base address does
  not start on the subnet boundary (Sara Pickett)
* cidrize() in prips.c no longer creates invalid CIDR notation.
  This is a _big_ improvement over the old functionality, which
  was "a trifle funky" :) (Sara Pickett)
* some random cleanups


## 0.9

### Started

* First public release

[Unreleased]: https://gitlab.com/prips/prips/-/compare/release%2F1.2.2...master
[1.2.2]: https://gitlab.com/prips/prips/-/compare/release%2F1.2.0...release%2F1.2.2
[1.2.0]: https://gitlab.com/prips/prips/-/compare/release%2F1.1.1...release%2F1.2.0
[1.1.1]: https://gitlab.com/prips/prips/-/compare/release%2F1.1.0...release%2F1.1.1
[1.1.0]: https://gitlab.com/prips/prips/-/compare/release%2F1.0.2...release%2F1.1.0
[1.0.2]: https://gitlab.com/prips/prips/-/compare/release%2F1.0.1...release%2F1.0.2
[1.0.1]: https://gitlab.com/prips/prips/-/compare/release%2F1.0.0...release%2F1.0.1
[1.0.0]: https://gitlab.com/prips/prips/-/compare/release%2F0.9.9...release%2F1.0.0
[0.9.9]: https://gitlab.com/prips/prips/-/compare/release%2F0.9.8...release%2F0.9.9
[0.9.8]: https://gitlab.com/prips/prips/-/compare/release%2F0.9.7...release%2F0.9.8
[0.9.7]: https://gitlab.com/prips/prips/-/compare/release%2F0.9.6...release%2F0.9.7
[0.9.6]: https://gitlab.com/prips/prips/-/compare/release%2F0.9.5...release%2F0.9.6
[0.9.5]: https://gitlab.com/prips/prips/-/compare/release%2F0.9.4...release%2F0.9.5
[0.9.4]: https://gitlab.com/prips/prips/-/tags/release%2F0.9.4
[contrib-tphilipp]: mailto:tphilipp@potion-studios.com "Tassilo Philipp"
[contrib-sposner]: mailto:sposner@gmx.de "Sebastian Posner"
