/* $Id: regiondb-write.h 222139 2020-03-13 00:15:01Z twu $ */
#ifndef REGIONDB_WRITE_INCLUDED
#define REGIONDB_WRITE_INCLUDED
#ifdef HAVE_CONFIG_H
#include <config.h>		/* For HAVE_64_BIT */
#endif

#include "bool.h"
#include "types.h"		/* For Oligospace_T */
#include "iit-read-univ.h"

#ifdef PMAP
#include "alphabet.h"
#endif

typedef Oligospace_T (*Reduce_fcn_T) (Oligospace_T);

void
Regiondb_write (char *destdir, char interval_char, FILE *sequence_fp, Univ_IIT_T chromosome_iit,
#ifdef PMAP
		Alphabet_T alphabet, Width_T region1part_aa, bool watsonp,
#else
		Width_T region1part,
#endif
		Width_T region1interval, bool genome_lc_p, char *fileroot, bool mask_lowercase_p,
		Reduce_fcn_T reduce_fcn);

extern void
Regiondb_cat (FILE *out, char **files, Univcoord_T *genomelengths, int nfiles, Width_T region1part);

#endif
