/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import org.fest.swing.core.FrameDisposer;
import org.fest.swing.core.MainThreadIdentifier;
import org.fest.swing.core.SimpleFallbackExceptionHandler;
import org.fest.swing.core.ThreadsSource;
import org.fest.swing.util.AWTExceptionHandlerInstaller;

class TestTerminator {
    private final ThreadsSource threadsSource;
    private final FrameDisposer frameDisposer;
    private final MainThreadIdentifier mainThreadIdentifier;

    TestTerminator() {
        this(new ThreadsSource(), new FrameDisposer(), new MainThreadIdentifier());
    }

    TestTerminator(ThreadsSource threadsSource, FrameDisposer frameDisposer, MainThreadIdentifier mainThreadIdentifier) {
        this.threadsSource = threadsSource;
        this.frameDisposer = frameDisposer;
        this.mainThreadIdentifier = mainThreadIdentifier;
    }

    void terminateTests() {
        this.pokeMainThread();
        this.frameDisposer.disposeFrames();
        throw new RuntimeException("User aborted FEST-Swing tests");
    }

    private void pokeMainThread() {
        Thread mainThread = this.mainThreadIdentifier.mainThreadIn(this.threadsSource.allThreads());
        if (mainThread != null) {
            mainThread.interrupt();
        }
    }

    static {
        AWTExceptionHandlerInstaller.installAWTExceptionHandler(SimpleFallbackExceptionHandler.class);
    }
}

