      SUBROUTINE SHXTRS (NROW,NCOL,ARRAY)
C
C     TO EXTRAPOLATE VALUES IN ARRAY FROM A SET OF EVALUATION POINTS TO
C     THE GRID POINTS OF SPECIFIC SHELL ELEMENTS.
C     THE EXTRAPOLATION IS IN TWO DIMENSIONS.
C
C     INPUT :
C           NROW   - SIZE OF THE SET OF VALUES
C           NCOL   - NUMBER OF EVALUATION POINTS
C           ARRAY  - ARRAY OF DATA TO BE EXTRAPOLATED
C
C     OUTPUT:
C           ARRAY  - ARRAY OF EXTRAPOLATED DATA
C
C
      LOGICAL TRIA
      REAL    ARRAY(NROW,1),TEMP(4,4),SHP(4),TPOINT(2,3),QPOINT(2,4),
     1        XSI,ETA
C
C
C
      DATA    TPOINT  / 0.0,  0.0,  1.0,  0.0,  0.0,  1.0             /
      DATA    QPOINT  /-1.0, -1.0,  1.0, -1.0,  1.0,  1.0, -1.0,  1.0 /
C
C     INITIALIZE
C
      TRIA   = NCOL .EQ. 3
C
      DO 10 I = 1,NROW
      DO 10 J = 1,NCOL
      TEMP(I,J) = 0.0
   10 CONTINUE
C
C     BEGIN LOOP ON DESTINATION POINTS
C
      DO 70 I = 1,NCOL
C
C     EVALUATE PSEUDO-SHAPE FUNCTIONS
C
      IF (.NOT.TRIA) GO TO 30
C
      XSI    = TPOINT(1,I)
      ETA    = TPOINT(2,I)
      SHP(1) = 1.66666667 - 2.0*XSI - 2.0*ETA
      SHP(2) = 2.0*XSI - 0.33333333
      SHP(3) = 2.0*ETA - 0.33333333
      GO TO 40
C
   30 XSI    = QPOINT(1,I)
      ETA    = QPOINT(2,I)
      CONST  = 0.577350269
      SHP(1) = 0.75*(CONST-XSI)*(CONST-ETA)
      SHP(2) = 0.75*(CONST-XSI)*(CONST+ETA)
      SHP(3) = 0.75*(CONST+XSI)*(CONST-ETA)
      SHP(4) = 0.75*(CONST+XSI)*(CONST+ETA)
C
C     EXTRAPOLATE
C
   40 DO 50 J = 1,NROW
      DO 50 K = 1,NCOL
      TEMP(J,I) = TEMP(J,I) + SHP(K)*ARRAY(J,K)
   50 CONTINUE
C
   70 CONTINUE
C
C     COPY THE EXTRAPOLATED DATA BACK INTO ARRAY
C
      DO 90 J = 1,NCOL
      DO 90 I = 1,NROW
      ARRAY(I,J) = TEMP(I,J)
   90 CONTINUE
C
      RETURN
      END
